/*
 * PWM.c
 *
 *  Created on: Mar 31, 2015
 *      Author: Jordan
 */

#include "etpwm.h"
#include "ecap.h"

uint32 receiver_PWM[6] = {0,0,0,0,0,0};

void set_PWM_width(uint8 ch, float32 width){
	// Limit width to 0-2.5ms (400 Hz limit)
	width = width > 2.5 ? 2.5 : width;
	width = width < 0 ? 0 : width;

	// Set compare
	uint16 cmp = (uint16) (width*20000);
	switch(ch){
		case 1: etpwmSetCmpB(etpwmREG2,cmp); break;
		case 2: etpwmSetCmpA(etpwmREG3,cmp); break;
		case 3: etpwmSetCmpB(etpwmREG3,cmp); break;
		case 4: etpwmSetCmpB(etpwmREG4,cmp); break;
		case 5: etpwmSetCmpA(etpwmREG6,cmp); break;
		case 6: etpwmSetCmpB(etpwmREG6,cmp); break;
		case 7: etpwmSetCmpA(etpwmREG7,cmp); break;
		case 8: etpwmSetCmpB(etpwmREG7,cmp); break;
	}
}

void set_PWM_width_all(float32 width){
	// Limit width to 0-2.5ms (400 Hz limit)
	width = width > 2.5 ? 2.5 : width;
	width = width < 0 ? 0 : width;

	// Set compare
	uint16 cmp = (uint16) (width*20000);
	etpwmSetCmpB(etpwmREG2,cmp);
	etpwmSetCmpA(etpwmREG3,cmp);
	etpwmSetCmpB(etpwmREG3,cmp);
	etpwmSetCmpB(etpwmREG4,cmp);
	etpwmSetCmpA(etpwmREG6,cmp);
	etpwmSetCmpB(etpwmREG6,cmp);
	etpwmSetCmpA(etpwmREG7,cmp);
	etpwmSetCmpB(etpwmREG7,cmp);
}

void set_PWM_duty(uint8 ch, float32 duty){
	// Limit duty to 0-100%
	duty = duty > 100 ? 100 : duty;
	duty = duty < 0 ? 0 : duty;

	// Set compare
	uint16 cmp = (uint16) (duty*500);
	switch(ch){
		case 1: etpwmSetCmpB(etpwmREG2,cmp); break;
		case 2: etpwmSetCmpA(etpwmREG3,cmp); break;
		case 3: etpwmSetCmpB(etpwmREG3,cmp); break;
		case 4: etpwmSetCmpB(etpwmREG4,cmp); break;
		case 5: etpwmSetCmpA(etpwmREG6,cmp); break;
		case 6: etpwmSetCmpB(etpwmREG6,cmp); break;
		case 7: etpwmSetCmpA(etpwmREG7,cmp); break;
		case 8: etpwmSetCmpB(etpwmREG7,cmp); break;
	}
}

void set_PWM_duty_all(float32 duty){
	// Limit duty to 0-100%
	duty = duty > 100 ? 100 : duty;
	duty = duty < 0 ? 0 : duty;

	// Set compare
	uint16 cmp = (uint16) (duty*500);
	etpwmSetCmpB(etpwmREG2,cmp);
	etpwmSetCmpA(etpwmREG3,cmp);
	etpwmSetCmpB(etpwmREG3,cmp);
	etpwmSetCmpB(etpwmREG4,cmp);
	etpwmSetCmpA(etpwmREG6,cmp);
	etpwmSetCmpB(etpwmREG6,cmp);
	etpwmSetCmpA(etpwmREG7,cmp);
	etpwmSetCmpB(etpwmREG7,cmp);
}

float32 get_PWM_width(uint8 ch){
	return (float32) receiver_PWM[ch-1]/20000;
}

float32 get_PWM_duty(uint8 ch){
	return (float32) receiver_PWM[ch-1]/500;
}

void ecapNotification(ecapBASE_t *ecap,uint16 flags)
{
	if(ecap == ecapREG1)
		receiver_PWM[0] = ecapGetCAP2(ecap);
	if(ecap == ecapREG2)
		receiver_PWM[1] = ecapGetCAP2(ecap);
	if(ecap == ecapREG3)
		receiver_PWM[2] = ecapGetCAP2(ecap);
	if(ecap == ecapREG4)
		receiver_PWM[3] = ecapGetCAP2(ecap);
	if(ecap == ecapREG5)
		receiver_PWM[4] = ecapGetCAP2(ecap);
	if(ecap == ecapREG6)
		receiver_PWM[5] = ecapGetCAP2(ecap);
}
